<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mailboxes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('parent_id')->nullable()->constrained('mailboxes');
            $table->string('subject');
            $table->longText('message');
            $table->enum('status', ['draft', 'sent', 'trash'])->default('draft');
            $table->tinyInteger('is_read')->default(0)->comment('1 = true, 0 = false');
            $table->tinyInteger('is_starred')->default(0)->comment('1 = true, 0 = false');
            $table->tinyInteger('is_important')->default(0)->comment('1 = true, 0 = false');
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mailboxes');
    }
};
