<?php

namespace Modules\Marsland\Transformers;

use App\Enums\DealType;
use App\Utils\Utils;
use Illuminate\Http\Resources\Json\JsonResource;

class PropertyFilterResource extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        $property = @$this->property;
        return [
            'id' => $property->id,
            'advertise_id' => $this->id,
            'name' => $property->name,
            'slug' => $property->slug,
            'address' => @$property->location->country->name ?? '-',
            'bedrooms' => $property->bedroom,
            'bathrooms' => $property->bathroom,
            'size' => $property->size,
            'booking_amount' => priceFormat($this->booking_amount),
            'price' => $this->getPrice(),
            'discount_amount' => $property->discount_type == 'fixed' ? priceFormat($property->discount_amount) : $property->discount_amount . '%',
            'discount_type' => $property->discount_type,
            'rent_type' => $this->rent_type == 1 ? 'Monthly' : null,
            'image' => apiAssetPath($property->defaultImage->path),
            'type' => $property->type,
            'vacant' => $property->vacant == 1 ? 'Vacant' : 'Occupied',
            'details_url' => route('property.detail', ['slug' => $property->slug, 'advertise_id' => $this->id]),  //
            'flat_no' => $property->flat_no,
            'completion' => $property->completion == 1 ? 'Ready' : 'Under Construction',
            'deal_type' => Utils::advertisementTypes()[$this->advertisement_type],
            'category' => @$property->category->name,
            'description' => $property->description,
            'user_email' => @$property->user->email,
            'user_phone' => @$property->user->phone,
        ];
    }


    public function getPrice()
    {
        $amount = 0;
        if ($this->advertisement_type == DealType::RENT) {
            $amount = $this->rent_amount;

        } elseif ($this->advertisement_type == DealType::SELL) {
            $amount = $this->sell_amount;
        }elseif($this->advertisement_type == DealType::MORTGAGE){
            $amount = $this->mortgage_amount;
        }elseif($this->advertisement_type == DealType::LEASE){
            $amount = $this->lease_amount;
        }

        return priceFormat($amount);
    }
}
