<?php

namespace App\Services;

use App\Models\Notification;

class NotificationService
{
    public static function notify($sender,$receiver, $title, $message )
    {

       try{
            return Notification::create([
                'title' => $title,
                'message' => $message,
                'sender_id' => $sender,
                'receiver_id' => $receiver,
                'is_read' => false,
                'read_at' => now(),
                'created_by'=> \auth()->id()
            ]);
       }catch(\Exception $th){
        return false;
       }
    }
}
