<?php

namespace Database\Seeders;

use App\Models\Image;
use App\Models\Partner;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PartnerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        if (env('HUBOFHOMES_THEME')){
            $lists = [
                'frontend/img/o_land_brand/1.jpeg',
                'frontend/img/o_land_brand/my_deposits.png',
                'frontend/img/o_land_brand/cmp.jpg',
                'frontend/img/o_land_brand/nla.png',
                'frontend/img/o_land_brand/ico.jpeg',
            ];
        }else{
            $lists = [
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
                'frontend/img/o_land_brand/pertner.png',
            ];
        }

        foreach ($lists as $key => $list) {
            $image = Image::create([
                'path' => $list,
            ]);
            $uploaded_partner_img[] = $image->id;
        }

        $partners = [];
        for ($i = 0; $i < count($lists); $i++) {
            $partners[] = [
                'name' => 'Partner' . $i,
                'image_id' => $uploaded_partner_img[$i],
                'status' => '1',
            ];
        }

        Partner::insert($partners);
    }
}
