@extends('backend.master')

@section('title')
    {{ $title }}
@endsection
@section('content')
    <x-container title="{{ $title }}"
                 :breadcrumbs="[['title' => 'Advertisement', 'route' => route('advertisements.index')], ['title' => 'Add New']]">
        <div class="card ot-card">
            <div class="card-body">
                <form action="{{ route('backend.appointment.store') }}" class="row" method="post">
                    @csrf
                    <x-forms.input
                        :required="true"
                        label="Name"
                        name="name"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Email"
                        name="email"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Phone"
                        name="phone"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Property Address"
                        name="property_address"
                    ></x-forms.input>

                    <x-forms.select
                        :required="true"
                        label="Property Type"
                        name="property_type">
                        <option value="letting">{{ _trans('common.Letting') }}</option>
                        <option value="sales">{{ _trans('common.Sales') }}
                    </x-forms.select>

                    <x-forms.input
                        col="col-lg-3 mb-3"
                        type="date"
                        label="Date"
                        name="date"
                    ></x-forms.input>

                    <x-forms.input
                        col="col-lg-3 mb-3"
                        type="time"
                        label="Time"
                        name="time"
                    ></x-forms.input>

                    <x-forms.textarea
                        label="Message"
                        name="message"
                    ></x-forms.textarea>
                    <x-button></x-button>
                </form>
            </div>
        </div>
    </x-container>
@endsection


@push('script')

@endpush
