<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lexend:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Lexend', sans-serif;
        }

        body {
            display: flex;
            flex-direction: column;
            height: 100vh;
            width: 100%;
            background: #f4f4f5;
        }

        .logo {
            width: 65px
        }

        .lock_sreen_warraper {
            widows: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .lock_screen_box {
            display: flex;
            flex-direction: column;
            gap: 5px;
            padding: 10px;
        }

        .lock_screen_box_heading {
            display: flex;
            justify-content: space-between;
            align-items: baseline;
        }   

        .lock_screen_box_title {
            font-size: .9rem;
        }

        .lock_screen_box_input {
            width: 350px;
            height: 40px;
            border: 2px solid #dfdfdf;
            outline: 0;
            padding-left: 30px;
            border-radius: 8px;
        }

        .lock_screen_box_input:focus {
            border: 2px solid #000000;
            transition: 3ms;
        }

        .lock_screen_box_form {
            position: relative;
            display: flex;
            align-items: center;
            gap: 0;
        }

        .lock_screen_box_avatar {
            width: 65px;
            height: 65px;
            border-radius: 50%;
            margin-right: -25px;
            z-index: 999;
        }

        button {
            position: absolute;
            top: 16px;
            right: 4px;
            border: 0;
            height: 32px;
            width: 32px;
            cursor: pointer;
            border-radius: 5px;
            padding: 5px
        }

        button:hover {
            background: #000000;
            color: #ffffff;
        }

        .arrow_icon {
            width: 100%;
            height: 100%;
        }
    </style>
</head>

<body>
    <div class="lock_sreen_warraper">
        <div class="lock_screen_box">
            <div class="lock_screen_box_heading">
                <a href="{{ url('/') }}">
                    <img 
                        class="logo"
                        src="{{ userTheme() == 'default-theme' ? @globalAsset(setting('light_logo'), '154x38.png') : @globalAsset(setting('dark_logo'), '154x38.png') }}"
                        alt="logo" 
                    />
                </a>
                <h3 class="lock_screen_box_title">Lock screen</h3>
            </div>
            <form action="#" method="POST" class="lock_screen_box_form">
                <img class="lock_screen_box_avatar" src="{{ asset('backend/assets/images/icons/user1.png') }}" alt="profile">
                <input type="password" class="lock_screen_box_input" placeholder="Enter your password" autocomplete="off" required>
                <button>
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" data-slot="icon" class="arrow_icon">
                        <path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                    </svg>                      
                </button>
            </form>
        </div>
    </div>
</body>
</html>