@extends('backend.master')
@section('title')
    {{ @$data['title'] }}
@endsection
@section('content')
    <div class="page-content">
        <!-- profile content start -->
        <div class="profile-content">
            <div class="d-flex flex-column flex-lg-row gap-4 gap-lg-0">
                <!-- profile menu mobile start -->
                <div class="profile-menu-mobile">
                    <button class="btn-menu-mobile" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#offcanvasWithBothOptionsMenuMobile"
                        aria-controls="offcanvasWithBothOptionsMenuMobile">
                        <span class="icon"><i class="fa-solid fa-bars"></i></span>
                    </button>

                    <div class="offcanvas offcanvas-start" data-bs-scroll="true" tabindex="-1"
                        id="offcanvasWithBothOptionsMenuMobile">
                        <div class="offcanvas-header">
                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                                <span class="icon"><i class="fa-solid fa-xmark"></i></span>
                            </button>
                        </div>
                        <div class="offcanvas-body">
                            <!-- profile menu start -->
                            <div class="profile-menu">
                                <!-- profile menu head start -->
                                @include('backend.partials.user_profile-menu')
                                <!-- profile menu head end -->

                                <!-- profile menu body start -->
                                <div class="profile-menu-body">
                                    @include('backend.partials.profile_nav')

                                </div>
                                <!-- profile menu body end -->
                            </div>
                            <!-- profile menu end -->
                        </div>
                    </div>
                </div>
                <!-- profile menu mobile end -->

                <!-- profile menu start -->
                <div class="profile-menu">
                    <!-- profile menu head start -->
                    @include('backend.partials.user_profile-menu')
                    <!-- profile menu head end -->

                    <!-- profile menu body start -->
                    <div class="profile-menu-body">
                        @include('backend.partials.profile_nav')
                    </div>
                    <!-- profile menu body end -->
                </div>
                <!-- profile menu end -->

                <!-- profile body start -->
                <div class="profile-body">
                    <div class="emergency-header-edit mb-16">
                        <h2 class="m-0">Transaction History</h2>

                        <a href="#" class="add-edit-btn">
                            <i class="fa-solid fa-plus"></i>
                        </a>
                    </div>



                    <div class="transaction-history-data">

                        <div class="row">
                            <div class="col-xxl-12">
                                <div class="card table-content table-basic mb-5">
                                    <div class="card-body">

                                        <div class="all-transactions">
                                            <div class="table-responsive table-height-350 niceScroll">
                                                <table class="table table-bordered">
                                                    <thead class="thead">
                                                        <tr>
                                                            <th class="serial">{{ _trans('landlord.Name') }}</th>
                                                            <th class="purchase">{{ _trans('landlord.Attachment') }}</th>
                                                            <th class="purchase">{{ _trans('landlord.Date') }}</th>
                                                            <th class="purchase">{{ _trans('landlord.Property Name') }}</th>
                                                            <th class="purchase">{{ _trans('landlord.Amount') }}</th>
                                                            <th class="purchase">{{ _trans('landlord.Invoice') }}</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="tbody">
                                                        @foreach ($transactions as $transaction)
                                                            <tr>
                                                                <td><b></b>{{ @$transaction->tenant->user->name }}</td>
                                                                <td><i class="fa-solid fa-paperclip"></i>
                                                                    {{ @$transaction->attachment->path }} </td>
                                                                <td>{{ @$transaction->date }}</td>
                                                                <td><i class="fa-regular fa-building"></i>
                                                                    {{ @$transaction->property->name }}</td>
                                                                <td><b><span
                                                                            class="text-success">${{ @$transaction->amount }}</span></b>
                                                                </td>
                                                                <td> <a class="btn btn-primary"
                                                                        href="{{ route('users.createPDF', $transaction->id) }}">
                                                                        <i class="fas fa-print"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>



                                <div class="transactions-details">
                                    <div class="transactions-details-info">

                                        <div class="emergency-header-edit mb-16">
                                            <h4 class="title m-0">{{ _trans('landlord.Add Transaction') }}</h4>
                                        </div>

                                        <form
                                            action="{{ route('users.profileDetailsStore', [$data['id'], 'transaction']) }}"
                                            enctype="multipart/form-data" method="post" id="visitForm">
                                            @csrf
                                            <div class="row">
                                                <input type="hidden" name="property_tenant_id"
                                                    value="{{ $transaction->tenant->id }}">
                                                <div class="col-xl-6 mb-3">
                                                    <label for="validationCustom04"
                                                        class="form-label">{{ _trans('landlord.Attachment') }} <span
                                                            class="fillable">*</span></label>
                                                    <label class="form-label"
                                                        for="inputImage">{{ _trans('common.image') }}</label>
                                                    <div class="ot_fileUploader left-side mb-3">
                                                        <input class="form-control" type="text" placeholder="Image"
                                                            readonly="" id="placeholder">
                                                        <button class="primary-btn-small-input" type="button">
                                                            <label class="btn btn-lg ot-btn-primary"
                                                                for="fileBrouse">Browse</label>
                                                            <input type="file" class="d-none form-control" name="image"
                                                                id="fileBrouse" accept="image/*">
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <label for="validationServer04"
                                                        class="form-label">{{ _trans('common.Transaction Type') }} <span
                                                            class="fillable">*</span></label>

                                                    <select
                                                        class="nice-select niceSelect bordered_style wide @error('status') is-invalid @enderror"
                                                        name="status" id="validationServer04"
                                                        aria-describedby="validationServer04Feedback">

                                                        <option value="{{ App\Enums\Status::ACTIVE }}">
                                                            {{ _trans('common.active') }}</option>
                                                        <option value="{{ App\Enums\Status::INACTIVE }}">
                                                            {{ _trans('common.inactive') }}
                                                        </option>
                                                    </select>
                                                    @error('status')
                                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror

                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <label for="validationServer04"
                                                        class="form-label">{{ _trans('common.Property Name') }} <span
                                                            class="fillable">*</span></label>
                                                    <select
                                                        class="nice-select niceSelect bordered_style wide @error('property_name') is-invalid @enderror"
                                                        name="property_id" id="validationServer04"
                                                        aria-describedby="validationServer04Feedback">
                                                        @foreach ($transactions as $transaction)
                                                            <option value="{{ $transaction->property->id }}">
                                                                {{ $transaction->property->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('property_name')
                                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror

                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <div class="form-group">
                                                        <label for="validationCustom04"
                                                            class="form-label">{{ _trans('landlord.Transaction Type') }}
                                                            <span class="fillable">*</span></label>
                                                        <select
                                                            class="nice-select niceSelect bordered_style wide @error('type') is-invalid @enderror"
                                                            name="type" id="validationServer04"
                                                            aria-describedby="validationServer04Feedback">

                                                            <option value="rent">
                                                                {{ _trans('common.Rent') }}
                                                            </option>
                                                            <option value="deposit">
                                                                {{ _trans('common.deposit') }}
                                                            </option>
                                                            <option value="other">
                                                                {{ _trans('common.other') }}
                                                            </option>
                                                            <option value="income">
                                                                {{ _trans('common.income') }}
                                                            </option>
                                                            <option value="expense">
                                                                {{ _trans('common.expense') }}
                                                            </option>
                                                        </select>
                                                        @error('type')
                                                            <div id="validationServer04Feedback" class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <div class="form-group">
                                                        <label for="validationCustom04"
                                                            class="form-label">{{ _trans('landlord.Payment Type') }}
                                                            <span class="fillable">*</span></label>
                                                        <select
                                                            class="nice-select niceSelect bordered_style wide @error('payment_method') is-invalid @enderror"
                                                            name="payment_method" id="validationServer04"
                                                            aria-describedby="validationServer04Feedback">

                                                            <option value="cash">
                                                                {{ _trans('common.cash') }}
                                                            </option>
                                                            <option value="cheque">
                                                                {{ _trans('common.cheque') }}
                                                            </option>
                                                            <option value="bank_transfer">
                                                                {{ _trans('common.bank_transfer') }}
                                                            </option>
                                                            <option value="online">
                                                                {{ _trans('common.online') }}
                                                            </option>
                                                            <option value="other">
                                                                {{ _trans('common.other') }}
                                                            </option>
                                                        </select>
                                                        @error('payment_method')
                                                            <div id="validationServer04Feedback" class="invalid-feedback">
                                                                {{ $message }}
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">{{ _trans('landlord.Date:') }} <span
                                                                class="fillable">*</span></label>
                                                        <input type="date" name="date"
                                                            class="form-control ot-input">
                                                    </div>
                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <div class="form-group">
                                                        <label for="validationServer04"
                                                            class="form-label">{{ _trans('landlord.Amount') }} <span
                                                                class="fillable">*</span></label>
                                                        <input type="number" class="form-control ot-input"
                                                            name="amount" id="validationCustom01" placeholder="$5555"
                                                            required="">
                                                    </div>
                                                </div>

                                                <div class="col-xl-6 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label"
                                                            for="exampleFormControlTextarea1">{{ _trans('landlord.Note') }}
                                                            <span class="fillable">*</span></label>
                                                        <textarea class="form-control ot-input m-0" name="note" placeholder="Note" id="exampleFormControlTextarea1"
                                                            rows="3"></textarea>
                                                    </div>
                                                </div>

                                                <div class="col-xl-12">
                                                    <div class="save-btn mt-3 text-center">
                                                        <button class="btn btn-lg btn-primary ot-btn-primary"
                                                            type="submit">
                                                            {{ _trans('landlord.Save') }}
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>

                                        </form>

                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>



                </div>
                <!-- profile body form end -->
            </div>
            <!-- profile body end -->
        </div>
    </div>
@endsection

@push('script')
    @include('backend.partials.delete-ajax')
@endpush
